package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateServiceResponse(
    service: zio.aws.apprunner.model.Service,
    operationId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateServiceResponse = {
    import CreateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateServiceResponse
      .builder()
      .service(service.buildAwsValue())
      .operationId(UUID.unwrap(operationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CreateServiceResponse.ReadOnly =
    zio.aws.apprunner.model.CreateServiceResponse.wrap(buildAwsValue())
}
object CreateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CreateServiceResponse =
      zio.aws.apprunner.model
        .CreateServiceResponse(service.asEditable, operationId)
    def service: zio.aws.apprunner.model.Service.ReadOnly
    def operationId: UUID
    def getService
        : ZIO[Any, Nothing, zio.aws.apprunner.model.Service.ReadOnly] =
      ZIO.succeed(service)
    def getOperationId: ZIO[Any, Nothing, UUID] = ZIO.succeed(operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateServiceResponse
  ) extends zio.aws.apprunner.model.CreateServiceResponse.ReadOnly {
    override val service: zio.aws.apprunner.model.Service.ReadOnly =
      zio.aws.apprunner.model.Service.wrap(impl.service())
    override val operationId: UUID =
      zio.aws.apprunner.model.primitives.UUID(impl.operationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateServiceResponse
  ): zio.aws.apprunner.model.CreateServiceResponse.ReadOnly = new Wrapper(impl)
}
