package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateConnectionResponse(
    connection: zio.aws.apprunner.model.Connection
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateConnectionResponse = {
    import CreateConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateConnectionResponse
      .builder()
      .connection(connection.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly =
    zio.aws.apprunner.model.CreateConnectionResponse.wrap(buildAwsValue())
}
object CreateConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CreateConnectionResponse =
      zio.aws.apprunner.model.CreateConnectionResponse(connection.asEditable)
    def connection: zio.aws.apprunner.model.Connection.ReadOnly
    def getConnection
        : ZIO[Any, Nothing, zio.aws.apprunner.model.Connection.ReadOnly] =
      ZIO.succeed(connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateConnectionResponse
  ) extends zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly {
    override val connection: zio.aws.apprunner.model.Connection.ReadOnly =
      zio.aws.apprunner.model.Connection.wrap(impl.connection())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateConnectionResponse
  ): zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
