package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigurationSource {
  def unwrap
      : software.amazon.awssdk.services.apprunner.model.ConfigurationSource
}
object ConfigurationSource {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.ConfigurationSource
  ): zio.aws.apprunner.model.ConfigurationSource = value match {
    case software.amazon.awssdk.services.apprunner.model.ConfigurationSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.ConfigurationSource.REPOSITORY =>
      val r = REPOSITORY
      r
    case software.amazon.awssdk.services.apprunner.model.ConfigurationSource.API =>
      val r = API
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.ConfigurationSource {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConfigurationSource =
      software.amazon.awssdk.services.apprunner.model.ConfigurationSource.UNKNOWN_TO_SDK_VERSION
  }
  case object REPOSITORY extends zio.aws.apprunner.model.ConfigurationSource {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConfigurationSource =
      software.amazon.awssdk.services.apprunner.model.ConfigurationSource.REPOSITORY
  }
  case object API extends zio.aws.apprunner.model.ConfigurationSource {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ConfigurationSource =
      software.amazon.awssdk.services.apprunner.model.ConfigurationSource.API
  }
}
