package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceStatus {
  def unwrap: software.amazon.awssdk.services.apprunner.model.ServiceStatus
}
object ServiceStatus {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.ServiceStatus
  ): zio.aws.apprunner.model.ServiceStatus = value match {
    case software.amazon.awssdk.services.apprunner.model.ServiceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.ServiceStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.apprunner.model.ServiceStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.apprunner.model.ServiceStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.apprunner.model.ServiceStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.apprunner.model.ServiceStatus.PAUSED =>
      val r = PAUSED
      r
    case software.amazon.awssdk.services.apprunner.model.ServiceStatus.OPERATION_IN_PROGRESS =>
      val r = OPERATION_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ServiceStatus =
      software.amazon.awssdk.services.apprunner.model.ServiceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_FAILED extends zio.aws.apprunner.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ServiceStatus =
      software.amazon.awssdk.services.apprunner.model.ServiceStatus.CREATE_FAILED
  }
  case object RUNNING extends zio.aws.apprunner.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ServiceStatus =
      software.amazon.awssdk.services.apprunner.model.ServiceStatus.RUNNING
  }
  case object DELETED extends zio.aws.apprunner.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ServiceStatus =
      software.amazon.awssdk.services.apprunner.model.ServiceStatus.DELETED
  }
  case object DELETE_FAILED extends zio.aws.apprunner.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ServiceStatus =
      software.amazon.awssdk.services.apprunner.model.ServiceStatus.DELETE_FAILED
  }
  case object PAUSED extends zio.aws.apprunner.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ServiceStatus =
      software.amazon.awssdk.services.apprunner.model.ServiceStatus.PAUSED
  }
  case object OPERATION_IN_PROGRESS
      extends zio.aws.apprunner.model.ServiceStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ServiceStatus =
      software.amazon.awssdk.services.apprunner.model.ServiceStatus.OPERATION_IN_PROGRESS
  }
}
