package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConnectionsResponse(
    connectionSummaryList: Iterable[zio.aws.apprunner.model.ConnectionSummary],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListConnectionsResponse = {
    import ListConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListConnectionsResponse
      .builder()
      .connectionSummaryList(connectionSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly =
    zio.aws.apprunner.model.ListConnectionsResponse.wrap(buildAwsValue())
}
object ListConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListConnectionsResponse =
      zio.aws.apprunner.model.ListConnectionsResponse(
        connectionSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def connectionSummaryList
        : List[zio.aws.apprunner.model.ConnectionSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getConnectionSummaryList: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.ConnectionSummary.ReadOnly
    ]] = ZIO.succeed(connectionSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListConnectionsResponse
  ) extends zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly {
    override val connectionSummaryList
        : List[zio.aws.apprunner.model.ConnectionSummary.ReadOnly] = impl
      .connectionSummaryList()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.ConnectionSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListConnectionsResponse
  ): zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
