package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EgressConfiguration(
    egressType: Option[zio.aws.apprunner.model.EgressType] = None,
    vpcConnectorArn: Option[AppRunnerResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.EgressConfiguration = {
    import EgressConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.EgressConfiguration
      .builder()
      .optionallyWith(egressType.map(value => value.unwrap))(_.egressType)
      .optionallyWith(
        vpcConnectorArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.vpcConnectorArn)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.EgressConfiguration.ReadOnly =
    zio.aws.apprunner.model.EgressConfiguration.wrap(buildAwsValue())
}
object EgressConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.EgressConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.EgressConfiguration =
      zio.aws.apprunner.model.EgressConfiguration(
        egressType.map(value => value),
        vpcConnectorArn.map(value => value)
      )
    def egressType: Option[zio.aws.apprunner.model.EgressType]
    def vpcConnectorArn: Option[AppRunnerResourceArn]
    def getEgressType: ZIO[Any, AwsError, zio.aws.apprunner.model.EgressType] =
      AwsError.unwrapOptionField("egressType", egressType)
    def getVpcConnectorArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("vpcConnectorArn", vpcConnectorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.EgressConfiguration
  ) extends zio.aws.apprunner.model.EgressConfiguration.ReadOnly {
    override val egressType: Option[zio.aws.apprunner.model.EgressType] = scala
      .Option(impl.egressType())
      .map(value => zio.aws.apprunner.model.EgressType.wrap(value))
    override val vpcConnectorArn: Option[AppRunnerResourceArn] = scala
      .Option(impl.vpcConnectorArn())
      .map(value =>
        zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.EgressConfiguration
  ): zio.aws.apprunner.model.EgressConfiguration.ReadOnly = new Wrapper(impl)
}
