package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  Integer,
  AppRunnerResourceArn,
  VpcConnectorName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class VpcConnector(
    vpcConnectorName: Option[VpcConnectorName] = None,
    vpcConnectorArn: Option[AppRunnerResourceArn] = None,
    vpcConnectorRevision: Option[Integer] = None,
    subnets: Option[Iterable[String]] = None,
    securityGroups: Option[Iterable[String]] = None,
    status: Option[zio.aws.apprunner.model.VpcConnectorStatus] = None,
    createdAt: Option[Timestamp] = None,
    deletedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.VpcConnector = {
    import VpcConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.VpcConnector
      .builder()
      .optionallyWith(
        vpcConnectorName.map(value =>
          VpcConnectorName.unwrap(value): java.lang.String
        )
      )(_.vpcConnectorName)
      .optionallyWith(
        vpcConnectorArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.vpcConnectorArn)
      .optionallyWith(
        vpcConnectorRevision.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.vpcConnectorRevision)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.VpcConnector.ReadOnly =
    zio.aws.apprunner.model.VpcConnector.wrap(buildAwsValue())
}
object VpcConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.VpcConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.VpcConnector =
      zio.aws.apprunner.model.VpcConnector(
        vpcConnectorName.map(value => value),
        vpcConnectorArn.map(value => value),
        vpcConnectorRevision.map(value => value),
        subnets.map(value => value),
        securityGroups.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        deletedAt.map(value => value)
      )
    def vpcConnectorName: Option[VpcConnectorName]
    def vpcConnectorArn: Option[AppRunnerResourceArn]
    def vpcConnectorRevision: Option[Integer]
    def subnets: Option[List[String]]
    def securityGroups: Option[List[String]]
    def status: Option[zio.aws.apprunner.model.VpcConnectorStatus]
    def createdAt: Option[Timestamp]
    def deletedAt: Option[Timestamp]
    def getVpcConnectorName: ZIO[Any, AwsError, VpcConnectorName] =
      AwsError.unwrapOptionField("vpcConnectorName", vpcConnectorName)
    def getVpcConnectorArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("vpcConnectorArn", vpcConnectorArn)
    def getVpcConnectorRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpcConnectorRevision", vpcConnectorRevision)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.apprunner.model.VpcConnectorStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.VpcConnector
  ) extends zio.aws.apprunner.model.VpcConnector.ReadOnly {
    override val vpcConnectorName: Option[VpcConnectorName] = scala
      .Option(impl.vpcConnectorName())
      .map(value => zio.aws.apprunner.model.primitives.VpcConnectorName(value))
    override val vpcConnectorArn: Option[AppRunnerResourceArn] = scala
      .Option(impl.vpcConnectorArn())
      .map(value =>
        zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
      )
    override val vpcConnectorRevision: Option[Integer] = scala
      .Option(impl.vpcConnectorRevision())
      .map(value => zio.aws.apprunner.model.primitives.Integer(value))
    override val subnets: Option[List[String]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroups: Option[List[String]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Option[zio.aws.apprunner.model.VpcConnectorStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.apprunner.model.VpcConnectorStatus.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val deletedAt: Option[Timestamp] = scala
      .Option(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.VpcConnector
  ): zio.aws.apprunner.model.VpcConnector.ReadOnly = new Wrapper(impl)
}
