package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: AppRunnerResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AppRunnerResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.apprunner.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListTagsForResourceRequest =
      zio.aws.apprunner.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AppRunnerResourceArn
    def getResourceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListTagsForResourceRequest
  ) extends zio.aws.apprunner.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListTagsForResourceRequest
  ): zio.aws.apprunner.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
