package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CertificateValidationRecord(
    name: Option[String] = None,
    `type`: Option[String] = None,
    value: Option[String] = None,
    status: Option[zio.aws.apprunner.model.CertificateValidationRecordStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord = {
    import CertificateValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly =
    zio.aws.apprunner.model.CertificateValidationRecord.wrap(buildAwsValue())
}
object CertificateValidationRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CertificateValidationRecord =
      zio.aws.apprunner.model.CertificateValidationRecord(
        name.map(value => value),
        `type`.map(value => value),
        value.map(value => value),
        status.map(value => value)
      )
    def name: Option[String]
    def `type`: Option[String]
    def value: Option[String]
    def status
        : Option[zio.aws.apprunner.model.CertificateValidationRecordStatus]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.CertificateValidationRecordStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
  ) extends zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val status
        : Option[zio.aws.apprunner.model.CertificateValidationRecordStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.apprunner.model.CertificateValidationRecordStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
  ): zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly = new Wrapper(
    impl
  )
}
