package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[zio.aws.apprunner.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.apprunner.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListTagsForResourceResponse =
      zio.aws.apprunner.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListTagsForResourceResponse
  ) extends zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListTagsForResourceResponse
  ): zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
