package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAutoScalingConfigurationsResponse(
    autoScalingConfigurationSummaryList: Iterable[
      zio.aws.apprunner.model.AutoScalingConfigurationSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse = {
    import ListAutoScalingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse
      .builder()
      .autoScalingConfigurationSummaryList(
        autoScalingConfigurationSummaryList.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly =
    zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListAutoScalingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse =
      zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse(
        autoScalingConfigurationSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def autoScalingConfigurationSummaryList
        : List[zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getAutoScalingConfigurationSummaryList: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
    ]] = ZIO.succeed(autoScalingConfigurationSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse
  ) extends zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly {
    override val autoScalingConfigurationSummaryList: List[
      zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
    ] = impl
      .autoScalingConfigurationSummaryList()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.AutoScalingConfigurationSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse
  ): zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
