package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListServicesResponse(
    serviceSummaryList: Iterable[zio.aws.apprunner.model.ServiceSummary],
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListServicesResponse = {
    import ListServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListServicesResponse
      .builder()
      .serviceSummaryList(serviceSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListServicesResponse.ReadOnly =
    zio.aws.apprunner.model.ListServicesResponse.wrap(buildAwsValue())
}
object ListServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListServicesResponse =
      zio.aws.apprunner.model.ListServicesResponse(
        serviceSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def serviceSummaryList
        : List[zio.aws.apprunner.model.ServiceSummary.ReadOnly]
    def nextToken: Option[String]
    def getServiceSummaryList: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.ServiceSummary.ReadOnly
    ]] = ZIO.succeed(serviceSummaryList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesResponse
  ) extends zio.aws.apprunner.model.ListServicesResponse.ReadOnly {
    override val serviceSummaryList
        : List[zio.aws.apprunner.model.ServiceSummary.ReadOnly] = impl
      .serviceSummaryList()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.ServiceSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesResponse
  ): zio.aws.apprunner.model.ListServicesResponse.ReadOnly = new Wrapper(impl)
}
