package zio.aws.apprunner.model
import scala.jdk.CollectionConverters.*
sealed trait Runtime {
  def unwrap: software.amazon.awssdk.services.apprunner.model.Runtime
}
object Runtime {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.Runtime
  ): zio.aws.apprunner.model.Runtime = value match {
    case software.amazon.awssdk.services.apprunner.model.Runtime.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.PYTHON_3 =>
      val r = PYTHON_3
      r
    case software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_12 =>
      val r = NODEJS_12
      r
  }
  case object unknownToSdkVersion extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.UNKNOWN_TO_SDK_VERSION
  }
  case object PYTHON_3 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.PYTHON_3
  }
  case object NODEJS_12 extends zio.aws.apprunner.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.Runtime =
      software.amazon.awssdk.services.apprunner.model.Runtime.NODEJS_12
  }
}
