package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{RoleArn, Memory, Cpu}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceConfiguration(
    cpu: Option[Cpu] = None,
    memory: Option[Memory] = None,
    instanceRoleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.InstanceConfiguration = {
    import InstanceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
      .builder()
      .optionallyWith(cpu.map(value => Cpu.unwrap(value): java.lang.String))(
        _.cpu
      )
      .optionallyWith(
        memory.map(value => Memory.unwrap(value): java.lang.String)
      )(_.memory)
      .optionallyWith(
        instanceRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.instanceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.InstanceConfiguration.ReadOnly =
    zio.aws.apprunner.model.InstanceConfiguration.wrap(buildAwsValue())
}
object InstanceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.InstanceConfiguration =
      zio.aws.apprunner.model.InstanceConfiguration(
        cpu.map(value => value),
        memory.map(value => value),
        instanceRoleArn.map(value => value)
      )
    def cpu: Option[Cpu]
    def memory: Option[Memory]
    def instanceRoleArn: Option[RoleArn]
    def getCpu: ZIO[Any, AwsError, Cpu] = AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, Memory] =
      AwsError.unwrapOptionField("memory", memory)
    def getInstanceRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("instanceRoleArn", instanceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
  ) extends zio.aws.apprunner.model.InstanceConfiguration.ReadOnly {
    override val cpu: Option[Cpu] = scala
      .Option(impl.cpu())
      .map(value => zio.aws.apprunner.model.primitives.Cpu(value))
    override val memory: Option[Memory] = scala
      .Option(impl.memory())
      .map(value => zio.aws.apprunner.model.primitives.Memory(value))
    override val instanceRoleArn: Option[RoleArn] = scala
      .Option(impl.instanceRoleArn())
      .map(value => zio.aws.apprunner.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.InstanceConfiguration
  ): zio.aws.apprunner.model.InstanceConfiguration.ReadOnly = new Wrapper(impl)
}
