package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  RuntimeEnvironmentVariablesValue,
  RuntimeEnvironmentVariablesKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImageConfiguration(
    runtimeEnvironmentVariables: Option[
      Map[RuntimeEnvironmentVariablesKey, RuntimeEnvironmentVariablesValue]
    ] = None,
    startCommand: Option[String] = None,
    port: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ImageConfiguration = {
    import ImageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ImageConfiguration
      .builder()
      .optionallyWith(
        runtimeEnvironmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (RuntimeEnvironmentVariablesKey.unwrap(
                key
              ): java.lang.String) -> (RuntimeEnvironmentVariablesValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.runtimeEnvironmentVariables)
      .optionallyWith(startCommand.map(value => value: java.lang.String))(
        _.startCommand
      )
      .optionallyWith(port.map(value => value: java.lang.String))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ImageConfiguration.ReadOnly =
    zio.aws.apprunner.model.ImageConfiguration.wrap(buildAwsValue())
}
object ImageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ImageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ImageConfiguration =
      zio.aws.apprunner.model.ImageConfiguration(
        runtimeEnvironmentVariables.map(value => value),
        startCommand.map(value => value),
        port.map(value => value)
      )
    def runtimeEnvironmentVariables: Option[
      Map[RuntimeEnvironmentVariablesKey, RuntimeEnvironmentVariablesValue]
    ]
    def startCommand: Option[String]
    def port: Option[String]
    def getRuntimeEnvironmentVariables: ZIO[Any, AwsError, Map[
      RuntimeEnvironmentVariablesKey,
      RuntimeEnvironmentVariablesValue
    ]] = AwsError.unwrapOptionField(
      "runtimeEnvironmentVariables",
      runtimeEnvironmentVariables
    )
    def getStartCommand: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startCommand", startCommand)
    def getPort: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ImageConfiguration
  ) extends zio.aws.apprunner.model.ImageConfiguration.ReadOnly {
    override val runtimeEnvironmentVariables: Option[
      Map[RuntimeEnvironmentVariablesKey, RuntimeEnvironmentVariablesValue]
    ] = scala
      .Option(impl.runtimeEnvironmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apprunner.model.primitives.RuntimeEnvironmentVariablesKey(
              key
            ) -> zio.aws.apprunner.model.primitives
              .RuntimeEnvironmentVariablesValue(value)
          })
          .toMap
      )
    override val startCommand: Option[String] =
      scala.Option(impl.startCommand()).map(value => value: String)
    override val port: Option[String] =
      scala.Option(impl.port()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ImageConfiguration
  ): zio.aws.apprunner.model.ImageConfiguration.ReadOnly = new Wrapper(impl)
}
