package zio.aws.apprunner.model
import java.lang.Integer
import zio.aws.apprunner.model.primitives.{
  NextToken,
  MaxResults,
  AutoScalingConfigurationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAutoScalingConfigurationsRequest(
    autoScalingConfigurationName: Option[AutoScalingConfigurationName] = None,
    latestOnly: Option[Boolean] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest = {
    import ListAutoScalingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
      .builder()
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(latestOnly.map(value => value: java.lang.Boolean))(
        _.latestOnly
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest.ReadOnly =
    zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListAutoScalingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest =
      zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest(
        autoScalingConfigurationName.map(value => value),
        latestOnly.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def autoScalingConfigurationName: Option[AutoScalingConfigurationName]
    def latestOnly: Option[Boolean]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getLatestOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("latestOnly", latestOnly)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
  ) extends zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest.ReadOnly {
    override val autoScalingConfigurationName
        : Option[AutoScalingConfigurationName] = scala
      .Option(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val latestOnly: Option[Boolean] =
      scala.Option(impl.latestOnly()).map(value => value: Boolean)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest
  ): zio.aws.apprunner.model.ListAutoScalingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
