package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{DomainName, AppRunnerResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateCustomDomainRequest(
    serviceArn: AppRunnerResourceArn,
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainRequest = {
    import DisassociateCustomDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DisassociateCustomDomainRequest.ReadOnly =
    zio.aws.apprunner.model.DisassociateCustomDomainRequest
      .wrap(buildAwsValue())
}
object DisassociateCustomDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DisassociateCustomDomainRequest =
      zio.aws.apprunner.model
        .DisassociateCustomDomainRequest(serviceArn, domainName)
    def serviceArn: AppRunnerResourceArn
    def domainName: DomainName
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainRequest
  ) extends zio.aws.apprunner.model.DisassociateCustomDomainRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val domainName: DomainName =
      zio.aws.apprunner.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainRequest
  ): zio.aws.apprunner.model.DisassociateCustomDomainRequest.ReadOnly =
    new Wrapper(impl)
}
