package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  Integer,
  AutoScalingConfigurationName,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AutoScalingConfiguration(
    autoScalingConfigurationArn: Option[AppRunnerResourceArn] = None,
    autoScalingConfigurationName: Option[AutoScalingConfigurationName] = None,
    autoScalingConfigurationRevision: Option[Integer] = None,
    latest: Option[Boolean] = None,
    status: Option[zio.aws.apprunner.model.AutoScalingConfigurationStatus] =
      None,
    maxConcurrency: Option[Integer] = None,
    minSize: Option[Integer] = None,
    maxSize: Option[Integer] = None,
    createdAt: Option[Timestamp] = None,
    deletedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration = {
    import AutoScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
      .builder()
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(
        autoScalingConfigurationRevision.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.autoScalingConfigurationRevision)
      .optionallyWith(latest.map(value => value: java.lang.Boolean))(_.latest)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxConcurrency.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxConcurrency)
      .optionallyWith(
        minSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.minSize)
      .optionallyWith(
        maxSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxSize)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly =
    zio.aws.apprunner.model.AutoScalingConfiguration.wrap(buildAwsValue())
}
object AutoScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AutoScalingConfiguration =
      zio.aws.apprunner.model.AutoScalingConfiguration(
        autoScalingConfigurationArn.map(value => value),
        autoScalingConfigurationName.map(value => value),
        autoScalingConfigurationRevision.map(value => value),
        latest.map(value => value),
        status.map(value => value),
        maxConcurrency.map(value => value),
        minSize.map(value => value),
        maxSize.map(value => value),
        createdAt.map(value => value),
        deletedAt.map(value => value)
      )
    def autoScalingConfigurationArn: Option[AppRunnerResourceArn]
    def autoScalingConfigurationName: Option[AutoScalingConfigurationName]
    def autoScalingConfigurationRevision: Option[Integer]
    def latest: Option[Boolean]
    def status: Option[zio.aws.apprunner.model.AutoScalingConfigurationStatus]
    def maxConcurrency: Option[Integer]
    def minSize: Option[Integer]
    def maxSize: Option[Integer]
    def createdAt: Option[Timestamp]
    def deletedAt: Option[Timestamp]
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getAutoScalingConfigurationRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationRevision",
        autoScalingConfigurationRevision
      )
    def getLatest: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("latest", latest)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.AutoScalingConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxConcurrency: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMinSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ) extends zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly {
    override val autoScalingConfigurationArn: Option[AppRunnerResourceArn] =
      scala
        .Option(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val autoScalingConfigurationName
        : Option[AutoScalingConfigurationName] = scala
      .Option(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val autoScalingConfigurationRevision: Option[Integer] = scala
      .Option(impl.autoScalingConfigurationRevision())
      .map(value => zio.aws.apprunner.model.primitives.Integer(value))
    override val latest: Option[Boolean] =
      scala.Option(impl.latest()).map(value => value: Boolean)
    override val status
        : Option[zio.aws.apprunner.model.AutoScalingConfigurationStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.apprunner.model.AutoScalingConfigurationStatus.wrap(value)
      )
    override val maxConcurrency: Option[Integer] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.apprunner.model.primitives.Integer(value))
    override val minSize: Option[Integer] = scala
      .Option(impl.minSize())
      .map(value => zio.aws.apprunner.model.primitives.Integer(value))
    override val maxSize: Option[Integer] = scala
      .Option(impl.maxSize())
      .map(value => zio.aws.apprunner.model.primitives.Integer(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val deletedAt: Option[Timestamp] = scala
      .Option(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfiguration
  ): zio.aws.apprunner.model.AutoScalingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
