package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  RuntimeEnvironmentVariablesValue,
  RuntimeEnvironmentVariablesKey,
  StartCommand,
  BuildCommand
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CodeConfigurationValues(
    runtime: zio.aws.apprunner.model.Runtime,
    buildCommand: Option[BuildCommand] = None,
    startCommand: Option[StartCommand] = None,
    port: Option[String] = None,
    runtimeEnvironmentVariables: Option[
      Map[RuntimeEnvironmentVariablesKey, RuntimeEnvironmentVariablesValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CodeConfigurationValues = {
    import CodeConfigurationValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CodeConfigurationValues
      .builder()
      .runtime(runtime.unwrap)
      .optionallyWith(
        buildCommand.map(value => BuildCommand.unwrap(value): java.lang.String)
      )(_.buildCommand)
      .optionallyWith(
        startCommand.map(value => StartCommand.unwrap(value): java.lang.String)
      )(_.startCommand)
      .optionallyWith(port.map(value => value: java.lang.String))(_.port)
      .optionallyWith(
        runtimeEnvironmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (RuntimeEnvironmentVariablesKey.unwrap(
                key
              ): java.lang.String) -> (RuntimeEnvironmentVariablesValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.runtimeEnvironmentVariables)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CodeConfigurationValues.ReadOnly =
    zio.aws.apprunner.model.CodeConfigurationValues.wrap(buildAwsValue())
}
object CodeConfigurationValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CodeConfigurationValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CodeConfigurationValues =
      zio.aws.apprunner.model.CodeConfigurationValues(
        runtime,
        buildCommand.map(value => value),
        startCommand.map(value => value),
        port.map(value => value),
        runtimeEnvironmentVariables.map(value => value)
      )
    def runtime: zio.aws.apprunner.model.Runtime
    def buildCommand: Option[BuildCommand]
    def startCommand: Option[StartCommand]
    def port: Option[String]
    def runtimeEnvironmentVariables: Option[
      Map[RuntimeEnvironmentVariablesKey, RuntimeEnvironmentVariablesValue]
    ]
    def getRuntime: ZIO[Any, Nothing, zio.aws.apprunner.model.Runtime] =
      ZIO.succeed(runtime)
    def getBuildCommand: ZIO[Any, AwsError, BuildCommand] =
      AwsError.unwrapOptionField("buildCommand", buildCommand)
    def getStartCommand: ZIO[Any, AwsError, StartCommand] =
      AwsError.unwrapOptionField("startCommand", startCommand)
    def getPort: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("port", port)
    def getRuntimeEnvironmentVariables: ZIO[Any, AwsError, Map[
      RuntimeEnvironmentVariablesKey,
      RuntimeEnvironmentVariablesValue
    ]] = AwsError.unwrapOptionField(
      "runtimeEnvironmentVariables",
      runtimeEnvironmentVariables
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CodeConfigurationValues
  ) extends zio.aws.apprunner.model.CodeConfigurationValues.ReadOnly {
    override val runtime: zio.aws.apprunner.model.Runtime =
      zio.aws.apprunner.model.Runtime.wrap(impl.runtime())
    override val buildCommand: Option[BuildCommand] = scala
      .Option(impl.buildCommand())
      .map(value => zio.aws.apprunner.model.primitives.BuildCommand(value))
    override val startCommand: Option[StartCommand] = scala
      .Option(impl.startCommand())
      .map(value => zio.aws.apprunner.model.primitives.StartCommand(value))
    override val port: Option[String] =
      scala.Option(impl.port()).map(value => value: String)
    override val runtimeEnvironmentVariables: Option[
      Map[RuntimeEnvironmentVariablesKey, RuntimeEnvironmentVariablesValue]
    ] = scala
      .Option(impl.runtimeEnvironmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apprunner.model.primitives.RuntimeEnvironmentVariablesKey(
              key
            ) -> zio.aws.apprunner.model.primitives
              .RuntimeEnvironmentVariablesValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CodeConfigurationValues
  ): zio.aws.apprunner.model.CodeConfigurationValues.ReadOnly = new Wrapper(
    impl
  )
}
