package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateServiceRequest(
    serviceArn: AppRunnerResourceArn,
    sourceConfiguration: Option[zio.aws.apprunner.model.SourceConfiguration] =
      None,
    instanceConfiguration: Option[
      zio.aws.apprunner.model.InstanceConfiguration
    ] = None,
    autoScalingConfigurationArn: Option[AppRunnerResourceArn] = None,
    healthCheckConfiguration: Option[
      zio.aws.apprunner.model.HealthCheckConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .optionallyWith(
        instanceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceConfiguration)
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        healthCheckConfiguration.map(value => value.buildAwsValue())
      )(_.healthCheckConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.UpdateServiceRequest.ReadOnly =
    zio.aws.apprunner.model.UpdateServiceRequest.wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.UpdateServiceRequest =
      zio.aws.apprunner.model.UpdateServiceRequest(
        serviceArn,
        sourceConfiguration.map(value => value.asEditable),
        instanceConfiguration.map(value => value.asEditable),
        autoScalingConfigurationArn.map(value => value),
        healthCheckConfiguration.map(value => value.asEditable)
      )
    def serviceArn: AppRunnerResourceArn
    def sourceConfiguration
        : Option[zio.aws.apprunner.model.SourceConfiguration.ReadOnly]
    def instanceConfiguration
        : Option[zio.aws.apprunner.model.InstanceConfiguration.ReadOnly]
    def autoScalingConfigurationArn: Option[AppRunnerResourceArn]
    def healthCheckConfiguration
        : Option[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly]
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.InstanceConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceConfiguration", instanceConfiguration)
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getHealthCheckConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "healthCheckConfiguration",
      healthCheckConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
  ) extends zio.aws.apprunner.model.UpdateServiceRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val sourceConfiguration
        : Option[zio.aws.apprunner.model.SourceConfiguration.ReadOnly] = scala
      .Option(impl.sourceConfiguration())
      .map(value => zio.aws.apprunner.model.SourceConfiguration.wrap(value))
    override val instanceConfiguration
        : Option[zio.aws.apprunner.model.InstanceConfiguration.ReadOnly] = scala
      .Option(impl.instanceConfiguration())
      .map(value => zio.aws.apprunner.model.InstanceConfiguration.wrap(value))
    override val autoScalingConfigurationArn: Option[AppRunnerResourceArn] =
      scala
        .Option(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val healthCheckConfiguration
        : Option[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly] =
      scala
        .Option(impl.healthCheckConfiguration())
        .map(value =>
          zio.aws.apprunner.model.HealthCheckConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
  ): zio.aws.apprunner.model.UpdateServiceRequest.ReadOnly = new Wrapper(impl)
}
