package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  AppRunnerResourceArn,
  ConnectionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ConnectionSummary(
    connectionName: Option[ConnectionName] = None,
    connectionArn: Option[AppRunnerResourceArn] = None,
    providerType: Option[zio.aws.apprunner.model.ProviderType] = None,
    status: Option[zio.aws.apprunner.model.ConnectionStatus] = None,
    createdAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ConnectionSummary = {
    import ConnectionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ConnectionSummary
      .builder()
      .optionallyWith(
        connectionName.map(value =>
          ConnectionName.unwrap(value): java.lang.String
        )
      )(_.connectionName)
      .optionallyWith(
        connectionArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ConnectionSummary.ReadOnly =
    zio.aws.apprunner.model.ConnectionSummary.wrap(buildAwsValue())
}
object ConnectionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ConnectionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ConnectionSummary =
      zio.aws.apprunner.model.ConnectionSummary(
        connectionName.map(value => value),
        connectionArn.map(value => value),
        providerType.map(value => value),
        status.map(value => value),
        createdAt.map(value => value)
      )
    def connectionName: Option[ConnectionName]
    def connectionArn: Option[AppRunnerResourceArn]
    def providerType: Option[zio.aws.apprunner.model.ProviderType]
    def status: Option[zio.aws.apprunner.model.ConnectionStatus]
    def createdAt: Option[Timestamp]
    def getConnectionName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("connectionName", connectionName)
    def getConnectionArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.apprunner.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.apprunner.model.ConnectionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ConnectionSummary
  ) extends zio.aws.apprunner.model.ConnectionSummary.ReadOnly {
    override val connectionName: Option[ConnectionName] = scala
      .Option(impl.connectionName())
      .map(value => zio.aws.apprunner.model.primitives.ConnectionName(value))
    override val connectionArn: Option[AppRunnerResourceArn] = scala
      .Option(impl.connectionArn())
      .map(value =>
        zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
      )
    override val providerType: Option[zio.aws.apprunner.model.ProviderType] =
      scala
        .Option(impl.providerType())
        .map(value => zio.aws.apprunner.model.ProviderType.wrap(value))
    override val status: Option[zio.aws.apprunner.model.ConnectionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.apprunner.model.ConnectionStatus.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ConnectionSummary
  ): zio.aws.apprunner.model.ConnectionSummary.ReadOnly = new Wrapper(impl)
}
