package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait ObservabilityConfigurationStatus {
  def unwrap: software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus
}
object ObservabilityConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus
  ): zio.aws.apprunner.model.ObservabilityConfigurationStatus = value match {
    case software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.ObservabilityConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus =
      software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE
      extends zio.aws.apprunner.model.ObservabilityConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus =
      software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus.ACTIVE
  }
  case object INACTIVE
      extends zio.aws.apprunner.model.ObservabilityConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus =
      software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus.INACTIVE
  }
}
