package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{NextToken, AppRunnerResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServicesForAutoScalingConfigurationResponse(
    serviceArnList: Iterable[AppRunnerResourceArn],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse = {
    import ListServicesForAutoScalingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse
      .builder()
      .serviceArnList(serviceArnList.map { item =>
        AppRunnerResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse.ReadOnly =
    zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse
      .wrap(buildAwsValue())
}
object ListServicesForAutoScalingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse =
      zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse(
        serviceArnList,
        nextToken.map(value => value)
      )
    def serviceArnList: List[AppRunnerResourceArn]
    def nextToken: Optional[NextToken]
    def getServiceArnList: ZIO[Any, Nothing, List[AppRunnerResourceArn]] =
      ZIO.succeed(serviceArnList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse
  ) extends zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse.ReadOnly {
    override val serviceArnList: List[AppRunnerResourceArn] = impl
      .serviceArnList()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.primitives.AppRunnerResourceArn(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse
  ): zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
