package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  NextToken,
  MaxResults,
  AppRunnerResourceArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListServicesForAutoScalingConfigurationRequest(
    autoScalingConfigurationArn: AppRunnerResourceArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest = {
    import ListServicesForAutoScalingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest
      .builder()
      .autoScalingConfigurationArn(
        AppRunnerResourceArn.unwrap(
          autoScalingConfigurationArn
        ): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationRequest.ReadOnly =
    zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationRequest
      .wrap(buildAwsValue())
}
object ListServicesForAutoScalingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationRequest =
      zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationRequest(
        autoScalingConfigurationArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def autoScalingConfigurationArn: AppRunnerResourceArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAutoScalingConfigurationArn
        : ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(autoScalingConfigurationArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest
  ) extends zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationRequest.ReadOnly {
    override val autoScalingConfigurationArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.autoScalingConfigurationArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest
  ): zio.aws.apprunner.model.ListServicesForAutoScalingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
