package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListObservabilityConfigurationsResponse(
    observabilityConfigurationSummaryList: Iterable[
      zio.aws.apprunner.model.ObservabilityConfigurationSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse = {
    import ListObservabilityConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse
      .builder()
      .observabilityConfigurationSummaryList(
        observabilityConfigurationSummaryList.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly =
    zio.aws.apprunner.model.ListObservabilityConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListObservabilityConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.ListObservabilityConfigurationsResponse =
      zio.aws.apprunner.model.ListObservabilityConfigurationsResponse(
        observabilityConfigurationSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def observabilityConfigurationSummaryList: List[
      zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getObservabilityConfigurationSummaryList: ZIO[Any, Nothing, List[
      zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
    ]] = ZIO.succeed(observabilityConfigurationSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse
  ) extends zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly {
    override val observabilityConfigurationSummaryList: List[
      zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
    ] = impl
      .observabilityConfigurationSummaryList()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.ObservabilityConfigurationSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse
  ): zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
