package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IngressConfiguration(
    isPubliclyAccessible: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.IngressConfiguration = {
    import IngressConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.IngressConfiguration
      .builder()
      .optionallyWith(
        isPubliclyAccessible.map(value => value: java.lang.Boolean)
      )(_.isPubliclyAccessible)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.IngressConfiguration.ReadOnly =
    zio.aws.apprunner.model.IngressConfiguration.wrap(buildAwsValue())
}
object IngressConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.IngressConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.IngressConfiguration =
      zio.aws.apprunner.model
        .IngressConfiguration(isPubliclyAccessible.map(value => value))
    def isPubliclyAccessible: Optional[Boolean]
    def getIsPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPubliclyAccessible", isPubliclyAccessible)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.IngressConfiguration
  ) extends zio.aws.apprunner.model.IngressConfiguration.ReadOnly {
    override val isPubliclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPubliclyAccessible())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.IngressConfiguration
  ): zio.aws.apprunner.model.IngressConfiguration.ReadOnly = new Wrapper(impl)
}
