package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.SourceDirectory
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CodeRepository(
    repositoryUrl: String,
    sourceCodeVersion: zio.aws.apprunner.model.SourceCodeVersion,
    codeConfiguration: Optional[zio.aws.apprunner.model.CodeConfiguration] =
      Optional.Absent,
    sourceDirectory: Optional[SourceDirectory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CodeRepository = {
    import CodeRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CodeRepository
      .builder()
      .repositoryUrl(repositoryUrl: java.lang.String)
      .sourceCodeVersion(sourceCodeVersion.buildAwsValue())
      .optionallyWith(codeConfiguration.map(value => value.buildAwsValue()))(
        _.codeConfiguration
      )
      .optionallyWith(
        sourceDirectory.map(value =>
          SourceDirectory.unwrap(value): java.lang.String
        )
      )(_.sourceDirectory)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CodeRepository.ReadOnly =
    zio.aws.apprunner.model.CodeRepository.wrap(buildAwsValue())
}
object CodeRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CodeRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CodeRepository =
      zio.aws.apprunner.model.CodeRepository(
        repositoryUrl,
        sourceCodeVersion.asEditable,
        codeConfiguration.map(value => value.asEditable),
        sourceDirectory.map(value => value)
      )
    def repositoryUrl: String
    def sourceCodeVersion: zio.aws.apprunner.model.SourceCodeVersion.ReadOnly
    def codeConfiguration
        : Optional[zio.aws.apprunner.model.CodeConfiguration.ReadOnly]
    def sourceDirectory: Optional[SourceDirectory]
    def getRepositoryUrl: ZIO[Any, Nothing, String] = ZIO.succeed(repositoryUrl)
    def getSourceCodeVersion: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.SourceCodeVersion.ReadOnly
    ] = ZIO.succeed(sourceCodeVersion)
    def getCodeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.CodeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("codeConfiguration", codeConfiguration)
    def getSourceDirectory: ZIO[Any, AwsError, SourceDirectory] =
      AwsError.unwrapOptionField("sourceDirectory", sourceDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CodeRepository
  ) extends zio.aws.apprunner.model.CodeRepository.ReadOnly {
    override val repositoryUrl: String = impl.repositoryUrl(): String
    override val sourceCodeVersion
        : zio.aws.apprunner.model.SourceCodeVersion.ReadOnly =
      zio.aws.apprunner.model.SourceCodeVersion.wrap(impl.sourceCodeVersion())
    override val codeConfiguration
        : Optional[zio.aws.apprunner.model.CodeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeConfiguration())
        .map(value => zio.aws.apprunner.model.CodeConfiguration.wrap(value))
    override val sourceDirectory: Optional[SourceDirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDirectory())
        .map(value => zio.aws.apprunner.model.primitives.SourceDirectory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CodeRepository
  ): zio.aws.apprunner.model.CodeRepository.ReadOnly = new Wrapper(impl)
}
