package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  IsDefault,
  HasAssociatedService,
  Timestamp,
  Integer,
  AutoScalingConfigurationName,
  AppRunnerResourceArn
}
import scala.jdk.CollectionConverters._
final case class AutoScalingConfigurationSummary(
    autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent,
    autoScalingConfigurationName: Optional[AutoScalingConfigurationName] =
      Optional.Absent,
    autoScalingConfigurationRevision: Optional[Integer] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    hasAssociatedService: Optional[HasAssociatedService] = Optional.Absent,
    isDefault: Optional[IsDefault] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary = {
    import AutoScalingConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
      .builder()
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(
        autoScalingConfigurationRevision.map(value => value: java.lang.Integer)
      )(_.autoScalingConfigurationRevision)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        hasAssociatedService.map(value =>
          HasAssociatedService.unwrap(value): java.lang.Boolean
        )
      )(_.hasAssociatedService)
      .optionallyWith(
        isDefault.map(value => IsDefault.unwrap(value): java.lang.Boolean)
      )(_.isDefault)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly =
    zio.aws.apprunner.model.AutoScalingConfigurationSummary
      .wrap(buildAwsValue())
}
object AutoScalingConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AutoScalingConfigurationSummary =
      zio.aws.apprunner.model.AutoScalingConfigurationSummary(
        autoScalingConfigurationArn.map(value => value),
        autoScalingConfigurationName.map(value => value),
        autoScalingConfigurationRevision.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        hasAssociatedService.map(value => value),
        isDefault.map(value => value)
      )
    def autoScalingConfigurationArn: Optional[AppRunnerResourceArn]
    def autoScalingConfigurationName: Optional[AutoScalingConfigurationName]
    def autoScalingConfigurationRevision: Optional[Integer]
    def status: Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus]
    def createdAt: Optional[Timestamp]
    def hasAssociatedService: Optional[HasAssociatedService]
    def isDefault: Optional[IsDefault]
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getAutoScalingConfigurationRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationRevision",
        autoScalingConfigurationRevision
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.AutoScalingConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getHasAssociatedService: ZIO[Any, AwsError, HasAssociatedService] =
      AwsError.unwrapOptionField("hasAssociatedService", hasAssociatedService)
    def getIsDefault: ZIO[Any, AwsError, IsDefault] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ) extends zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly {
    override val autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val autoScalingConfigurationName
        : Optional[AutoScalingConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val autoScalingConfigurationRevision: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationRevision())
        .map(value => value: Integer)
    override val status
        : Optional[zio.aws.apprunner.model.AutoScalingConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.apprunner.model.AutoScalingConfigurationStatus.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val hasAssociatedService: Optional[HasAssociatedService] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hasAssociatedService())
        .map(value =>
          zio.aws.apprunner.model.primitives.HasAssociatedService(value)
        )
    override val isDefault: Optional[IsDefault] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => zio.aws.apprunner.model.primitives.IsDefault(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ): zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
