package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait OperationType {
  def unwrap: software.amazon.awssdk.services.apprunner.model.OperationType
}
object OperationType {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.OperationType
  ): zio.aws.apprunner.model.OperationType = value match {
    case software.amazon.awssdk.services.apprunner.model.OperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.OperationType.START_DEPLOYMENT =>
      val r = START_DEPLOYMENT
      r
    case software.amazon.awssdk.services.apprunner.model.OperationType.CREATE_SERVICE =>
      val r = CREATE_SERVICE
      r
    case software.amazon.awssdk.services.apprunner.model.OperationType.PAUSE_SERVICE =>
      val r = PAUSE_SERVICE
      r
    case software.amazon.awssdk.services.apprunner.model.OperationType.RESUME_SERVICE =>
      val r = RESUME_SERVICE
      r
    case software.amazon.awssdk.services.apprunner.model.OperationType.DELETE_SERVICE =>
      val r = DELETE_SERVICE
      r
    case software.amazon.awssdk.services.apprunner.model.OperationType.UPDATE_SERVICE =>
      val r = UPDATE_SERVICE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationType =
      software.amazon.awssdk.services.apprunner.model.OperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object START_DEPLOYMENT extends zio.aws.apprunner.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationType =
      software.amazon.awssdk.services.apprunner.model.OperationType.START_DEPLOYMENT
  }
  case object CREATE_SERVICE extends zio.aws.apprunner.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationType =
      software.amazon.awssdk.services.apprunner.model.OperationType.CREATE_SERVICE
  }
  case object PAUSE_SERVICE extends zio.aws.apprunner.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationType =
      software.amazon.awssdk.services.apprunner.model.OperationType.PAUSE_SERVICE
  }
  case object RESUME_SERVICE extends zio.aws.apprunner.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationType =
      software.amazon.awssdk.services.apprunner.model.OperationType.RESUME_SERVICE
  }
  case object DELETE_SERVICE extends zio.aws.apprunner.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationType =
      software.amazon.awssdk.services.apprunner.model.OperationType.DELETE_SERVICE
  }
  case object UPDATE_SERVICE extends zio.aws.apprunner.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationType =
      software.amazon.awssdk.services.apprunner.model.OperationType.UPDATE_SERVICE
  }
}
