package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVpcIngressConnectionsRequest(
    filter: Optional[zio.aws.apprunner.model.ListVpcIngressConnectionsFilter] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsRequest = {
    import ListVpcIngressConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListVpcIngressConnectionsRequest.ReadOnly =
    zio.aws.apprunner.model.ListVpcIngressConnectionsRequest
      .wrap(buildAwsValue())
}
object ListVpcIngressConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListVpcIngressConnectionsRequest =
      zio.aws.apprunner.model.ListVpcIngressConnectionsRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[
      zio.aws.apprunner.model.ListVpcIngressConnectionsFilter.ReadOnly
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.ListVpcIngressConnectionsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsRequest
  ) extends zio.aws.apprunner.model.ListVpcIngressConnectionsRequest.ReadOnly {
    override val filter: Optional[
      zio.aws.apprunner.model.ListVpcIngressConnectionsFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        zio.aws.apprunner.model.ListVpcIngressConnectionsFilter.wrap(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsRequest
  ): zio.aws.apprunner.model.ListVpcIngressConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
