package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.ServiceMaxResults
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListServicesRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ServiceMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListServicesRequest = {
    import ListServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListServicesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ServiceMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListServicesRequest.ReadOnly =
    zio.aws.apprunner.model.ListServicesRequest.wrap(buildAwsValue())
}
object ListServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListServicesRequest =
      zio.aws.apprunner.model.ListServicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[ServiceMaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ServiceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesRequest
  ) extends zio.aws.apprunner.model.ListServicesRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ServiceMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.ServiceMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListServicesRequest
  ): zio.aws.apprunner.model.ListServicesRequest.ReadOnly = new Wrapper(impl)
}
