package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteConnectionResponse(
    connection: Optional[zio.aws.apprunner.model.Connection] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DeleteConnectionResponse = {
    import DeleteConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DeleteConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly =
    zio.aws.apprunner.model.DeleteConnectionResponse.wrap(buildAwsValue())
}
object DeleteConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DeleteConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DeleteConnectionResponse =
      zio.aws.apprunner.model
        .DeleteConnectionResponse(connection.map(value => value.asEditable))
    def connection: Optional[zio.aws.apprunner.model.Connection.ReadOnly]
    def getConnection
        : ZIO[Any, AwsError, zio.aws.apprunner.model.Connection.ReadOnly] =
      AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteConnectionResponse
  ) extends zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.apprunner.model.Connection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.apprunner.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteConnectionResponse
  ): zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
