package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  VpcIngressConnectionName,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcIngressConnectionRequest(
    serviceArn: AppRunnerResourceArn,
    vpcIngressConnectionName: VpcIngressConnectionName,
    ingressVpcConfiguration: zio.aws.apprunner.model.IngressVpcConfiguration,
    tags: Optional[Iterable[zio.aws.apprunner.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateVpcIngressConnectionRequest = {
    import CreateVpcIngressConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateVpcIngressConnectionRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .vpcIngressConnectionName(
        VpcIngressConnectionName.unwrap(
          vpcIngressConnectionName
        ): java.lang.String
      )
      .ingressVpcConfiguration(ingressVpcConfiguration.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.CreateVpcIngressConnectionRequest.ReadOnly =
    zio.aws.apprunner.model.CreateVpcIngressConnectionRequest
      .wrap(buildAwsValue())
}
object CreateVpcIngressConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateVpcIngressConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CreateVpcIngressConnectionRequest =
      zio.aws.apprunner.model.CreateVpcIngressConnectionRequest(
        serviceArn,
        vpcIngressConnectionName,
        ingressVpcConfiguration.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceArn: AppRunnerResourceArn
    def vpcIngressConnectionName: VpcIngressConnectionName
    def ingressVpcConfiguration
        : zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly
    def tags: Optional[List[zio.aws.apprunner.model.Tag.ReadOnly]]
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getVpcIngressConnectionName
        : ZIO[Any, Nothing, VpcIngressConnectionName] =
      ZIO.succeed(vpcIngressConnectionName)
    def getIngressVpcConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly
    ] = ZIO.succeed(ingressVpcConfiguration)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateVpcIngressConnectionRequest
  ) extends zio.aws.apprunner.model.CreateVpcIngressConnectionRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val vpcIngressConnectionName: VpcIngressConnectionName =
      zio.aws.apprunner.model.primitives
        .VpcIngressConnectionName(impl.vpcIngressConnectionName())
    override val ingressVpcConfiguration
        : zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly =
      zio.aws.apprunner.model.IngressVpcConfiguration
        .wrap(impl.ingressVpcConfiguration())
    override val tags: Optional[List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateVpcIngressConnectionRequest
  ): zio.aws.apprunner.model.CreateVpcIngressConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
