package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CertificateValidationRecord(
    name: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    status: Optional[
      zio.aws.apprunner.model.CertificateValidationRecordStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord = {
    import CertificateValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly =
    zio.aws.apprunner.model.CertificateValidationRecord.wrap(buildAwsValue())
}
object CertificateValidationRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CertificateValidationRecord =
      zio.aws.apprunner.model.CertificateValidationRecord(
        name.map(value => value),
        `type`.map(value => value),
        value.map(value => value),
        status.map(value => value)
      )
    def name: Optional[String]
    def `type`: Optional[String]
    def value: Optional[String]
    def status
        : Optional[zio.aws.apprunner.model.CertificateValidationRecordStatus]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.CertificateValidationRecordStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
  ) extends zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.apprunner.model.CertificateValidationRecordStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.apprunner.model.CertificateValidationRecordStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord
  ): zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly = new Wrapper(
    impl
  )
}
