package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait AutoScalingConfigurationStatus {
  def unwrap: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus
}
object AutoScalingConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus
  ): zio.aws.apprunner.model.AutoScalingConfigurationStatus = value match {
    case software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.AutoScalingConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus =
      software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE
      extends zio.aws.apprunner.model.AutoScalingConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus =
      software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus.ACTIVE
  }
  case object INACTIVE
      extends zio.aws.apprunner.model.AutoScalingConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus =
      software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus.INACTIVE
  }
}
