package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateServiceRequest(
    serviceArn: AppRunnerResourceArn,
    sourceConfiguration: Optional[zio.aws.apprunner.model.SourceConfiguration] =
      Optional.Absent,
    instanceConfiguration: Optional[
      zio.aws.apprunner.model.InstanceConfiguration
    ] = Optional.Absent,
    autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent,
    healthCheckConfiguration: Optional[
      zio.aws.apprunner.model.HealthCheckConfiguration
    ] = Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.apprunner.model.NetworkConfiguration
    ] = Optional.Absent,
    observabilityConfiguration: Optional[
      zio.aws.apprunner.model.ServiceObservabilityConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .optionallyWith(
        instanceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceConfiguration)
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        healthCheckConfiguration.map(value => value.buildAwsValue())
      )(_.healthCheckConfiguration)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        observabilityConfiguration.map(value => value.buildAwsValue())
      )(_.observabilityConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.UpdateServiceRequest.ReadOnly =
    zio.aws.apprunner.model.UpdateServiceRequest.wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.UpdateServiceRequest =
      zio.aws.apprunner.model.UpdateServiceRequest(
        serviceArn,
        sourceConfiguration.map(value => value.asEditable),
        instanceConfiguration.map(value => value.asEditable),
        autoScalingConfigurationArn.map(value => value),
        healthCheckConfiguration.map(value => value.asEditable),
        networkConfiguration.map(value => value.asEditable),
        observabilityConfiguration.map(value => value.asEditable)
      )
    def serviceArn: AppRunnerResourceArn
    def sourceConfiguration
        : Optional[zio.aws.apprunner.model.SourceConfiguration.ReadOnly]
    def instanceConfiguration
        : Optional[zio.aws.apprunner.model.InstanceConfiguration.ReadOnly]
    def autoScalingConfigurationArn: Optional[AppRunnerResourceArn]
    def healthCheckConfiguration
        : Optional[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly]
    def networkConfiguration
        : Optional[zio.aws.apprunner.model.NetworkConfiguration.ReadOnly]
    def observabilityConfiguration: Optional[
      zio.aws.apprunner.model.ServiceObservabilityConfiguration.ReadOnly
    ]
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.InstanceConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceConfiguration", instanceConfiguration)
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getHealthCheckConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "healthCheckConfiguration",
      healthCheckConfiguration
    )
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getObservabilityConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.ServiceObservabilityConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "observabilityConfiguration",
      observabilityConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
  ) extends zio.aws.apprunner.model.UpdateServiceRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val sourceConfiguration
        : Optional[zio.aws.apprunner.model.SourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConfiguration())
        .map(value => zio.aws.apprunner.model.SourceConfiguration.wrap(value))
    override val instanceConfiguration
        : Optional[zio.aws.apprunner.model.InstanceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceConfiguration())
        .map(value => zio.aws.apprunner.model.InstanceConfiguration.wrap(value))
    override val autoScalingConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val healthCheckConfiguration
        : Optional[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckConfiguration())
        .map(value =>
          zio.aws.apprunner.model.HealthCheckConfiguration.wrap(value)
        )
    override val networkConfiguration
        : Optional[zio.aws.apprunner.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.apprunner.model.NetworkConfiguration.wrap(value))
    override val observabilityConfiguration: Optional[
      zio.aws.apprunner.model.ServiceObservabilityConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.observabilityConfiguration())
      .map(value =>
        zio.aws.apprunner.model.ServiceObservabilityConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest
  ): zio.aws.apprunner.model.UpdateServiceRequest.ReadOnly = new Wrapper(impl)
}
