package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceObservabilityConfiguration(
    observabilityEnabled: Boolean,
    observabilityConfigurationArn: Optional[AppRunnerResourceArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ServiceObservabilityConfiguration = {
    import ServiceObservabilityConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ServiceObservabilityConfiguration
      .builder()
      .observabilityEnabled(observabilityEnabled: java.lang.Boolean)
      .optionallyWith(
        observabilityConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.observabilityConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ServiceObservabilityConfiguration.ReadOnly =
    zio.aws.apprunner.model.ServiceObservabilityConfiguration
      .wrap(buildAwsValue())
}
object ServiceObservabilityConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ServiceObservabilityConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ServiceObservabilityConfiguration =
      zio.aws.apprunner.model.ServiceObservabilityConfiguration(
        observabilityEnabled,
        observabilityConfigurationArn.map(value => value)
      )
    def observabilityEnabled: Boolean
    def observabilityConfigurationArn: Optional[AppRunnerResourceArn]
    def getObservabilityEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(observabilityEnabled)
    def getObservabilityConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "observabilityConfigurationArn",
      observabilityConfigurationArn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ServiceObservabilityConfiguration
  ) extends zio.aws.apprunner.model.ServiceObservabilityConfiguration.ReadOnly {
    override val observabilityEnabled: Boolean =
      impl.observabilityEnabled(): Boolean
    override val observabilityConfigurationArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.observabilityConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ServiceObservabilityConfiguration
  ): zio.aws.apprunner.model.ServiceObservabilityConfiguration.ReadOnly =
    new Wrapper(impl)
}
