package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVpcIngressConnectionsFilter(
    serviceArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    vpcEndpointId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsFilter = {
    import ListVpcIngressConnectionsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsFilter
      .builder()
      .optionallyWith(
        serviceArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.serviceArn)
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListVpcIngressConnectionsFilter.ReadOnly =
    zio.aws.apprunner.model.ListVpcIngressConnectionsFilter
      .wrap(buildAwsValue())
}
object ListVpcIngressConnectionsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListVpcIngressConnectionsFilter =
      zio.aws.apprunner.model.ListVpcIngressConnectionsFilter(
        serviceArn.map(value => value),
        vpcEndpointId.map(value => value)
      )
    def serviceArn: Optional[AppRunnerResourceArn]
    def vpcEndpointId: Optional[String]
    def getServiceArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsFilter
  ) extends zio.aws.apprunner.model.ListVpcIngressConnectionsFilter.ReadOnly {
    override val serviceArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsFilter
  ): zio.aws.apprunner.model.ListVpcIngressConnectionsFilter.ReadOnly =
    new Wrapper(impl)
}
