package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOperationsResponse(
    operationSummaryList: Optional[
      Iterable[zio.aws.apprunner.model.OperationSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListOperationsResponse = {
    import ListOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListOperationsResponse
      .builder()
      .optionallyWith(
        operationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operationSummaryList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListOperationsResponse.ReadOnly =
    zio.aws.apprunner.model.ListOperationsResponse.wrap(buildAwsValue())
}
object ListOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListOperationsResponse =
      zio.aws.apprunner.model.ListOperationsResponse(
        operationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def operationSummaryList
        : Optional[List[zio.aws.apprunner.model.OperationSummary.ReadOnly]]
    def nextToken: Optional[String]
    def getOperationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.apprunner.model.OperationSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("operationSummaryList", operationSummaryList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListOperationsResponse
  ) extends zio.aws.apprunner.model.ListOperationsResponse.ReadOnly {
    override val operationSummaryList
        : Optional[List[zio.aws.apprunner.model.OperationSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.OperationSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListOperationsResponse
  ): zio.aws.apprunner.model.ListOperationsResponse.ReadOnly = new Wrapper(impl)
}
