package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  AppRunnerResourceArn,
  ConnectionName
}
import scala.jdk.CollectionConverters._
final case class ConnectionSummary(
    connectionName: Optional[ConnectionName] = Optional.Absent,
    connectionArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    providerType: Optional[zio.aws.apprunner.model.ProviderType] =
      Optional.Absent,
    status: Optional[zio.aws.apprunner.model.ConnectionStatus] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ConnectionSummary = {
    import ConnectionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ConnectionSummary
      .builder()
      .optionallyWith(
        connectionName.map(value =>
          ConnectionName.unwrap(value): java.lang.String
        )
      )(_.connectionName)
      .optionallyWith(
        connectionArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ConnectionSummary.ReadOnly =
    zio.aws.apprunner.model.ConnectionSummary.wrap(buildAwsValue())
}
object ConnectionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ConnectionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ConnectionSummary =
      zio.aws.apprunner.model.ConnectionSummary(
        connectionName.map(value => value),
        connectionArn.map(value => value),
        providerType.map(value => value),
        status.map(value => value),
        createdAt.map(value => value)
      )
    def connectionName: Optional[ConnectionName]
    def connectionArn: Optional[AppRunnerResourceArn]
    def providerType: Optional[zio.aws.apprunner.model.ProviderType]
    def status: Optional[zio.aws.apprunner.model.ConnectionStatus]
    def createdAt: Optional[Timestamp]
    def getConnectionName: ZIO[Any, AwsError, ConnectionName] =
      AwsError.unwrapOptionField("connectionName", connectionName)
    def getConnectionArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.apprunner.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.apprunner.model.ConnectionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ConnectionSummary
  ) extends zio.aws.apprunner.model.ConnectionSummary.ReadOnly {
    override val connectionName: Optional[ConnectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionName())
        .map(value => zio.aws.apprunner.model.primitives.ConnectionName(value))
    override val connectionArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val providerType: Optional[zio.aws.apprunner.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value => zio.aws.apprunner.model.ProviderType.wrap(value))
    override val status: Optional[zio.aws.apprunner.model.ConnectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.apprunner.model.ConnectionStatus.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ConnectionSummary
  ): zio.aws.apprunner.model.ConnectionSummary.ReadOnly = new Wrapper(impl)
}
