package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDeploymentRequest(serviceArn: AppRunnerResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.StartDeploymentRequest = {
    import StartDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.StartDeploymentRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.StartDeploymentRequest.ReadOnly =
    zio.aws.apprunner.model.StartDeploymentRequest.wrap(buildAwsValue())
}
object StartDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.StartDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.StartDeploymentRequest =
      zio.aws.apprunner.model.StartDeploymentRequest(serviceArn)
    def serviceArn: AppRunnerResourceArn
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.StartDeploymentRequest
  ) extends zio.aws.apprunner.model.StartDeploymentRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.StartDeploymentRequest
  ): zio.aws.apprunner.model.StartDeploymentRequest.ReadOnly = new Wrapper(impl)
}
