package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TraceConfiguration(
    vendor: zio.aws.apprunner.model.TracingVendor
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.TraceConfiguration = {
    import TraceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.TraceConfiguration
      .builder()
      .vendor(vendor.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.TraceConfiguration.ReadOnly =
    zio.aws.apprunner.model.TraceConfiguration.wrap(buildAwsValue())
}
object TraceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.TraceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.TraceConfiguration =
      zio.aws.apprunner.model.TraceConfiguration(vendor)
    def vendor: zio.aws.apprunner.model.TracingVendor
    def getVendor: ZIO[Any, Nothing, zio.aws.apprunner.model.TracingVendor] =
      ZIO.succeed(vendor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.TraceConfiguration
  ) extends zio.aws.apprunner.model.TraceConfiguration.ReadOnly {
    override val vendor: zio.aws.apprunner.model.TracingVendor =
      zio.aws.apprunner.model.TracingVendor.wrap(impl.vendor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.TraceConfiguration
  ): zio.aws.apprunner.model.TraceConfiguration.ReadOnly = new Wrapper(impl)
}
