package zio.aws.apprunner.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  NextToken,
  MaxResults,
  ObservabilityConfigurationName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListObservabilityConfigurationsRequest(
    observabilityConfigurationName: Optional[ObservabilityConfigurationName] =
      Optional.Absent,
    latestOnly: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest = {
    import ListObservabilityConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest
      .builder()
      .optionallyWith(
        observabilityConfigurationName.map(value =>
          ObservabilityConfigurationName.unwrap(value): java.lang.String
        )
      )(_.observabilityConfigurationName)
      .optionallyWith(latestOnly.map(value => value: java.lang.Boolean))(
        _.latestOnly
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.ListObservabilityConfigurationsRequest.ReadOnly =
    zio.aws.apprunner.model.ListObservabilityConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListObservabilityConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.ListObservabilityConfigurationsRequest =
      zio.aws.apprunner.model.ListObservabilityConfigurationsRequest(
        observabilityConfigurationName.map(value => value),
        latestOnly.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def observabilityConfigurationName: Optional[ObservabilityConfigurationName]
    def latestOnly: Optional[Boolean]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getObservabilityConfigurationName
        : ZIO[Any, AwsError, ObservabilityConfigurationName] =
      AwsError.unwrapOptionField(
        "observabilityConfigurationName",
        observabilityConfigurationName
      )
    def getLatestOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("latestOnly", latestOnly)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest
  ) extends zio.aws.apprunner.model.ListObservabilityConfigurationsRequest.ReadOnly {
    override val observabilityConfigurationName
        : Optional[ObservabilityConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.observabilityConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.ObservabilityConfigurationName(value)
      )
    override val latestOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.latestOnly())
      .map(value => value: Boolean)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.apprunner.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apprunner.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest
  ): zio.aws.apprunner.model.ListObservabilityConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
