package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateCustomDomainResponse(
    dnsTarget: String,
    serviceArn: AppRunnerResourceArn,
    customDomain: zio.aws.apprunner.model.CustomDomain
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse = {
    import AssociateCustomDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
      .builder()
      .dnsTarget(dnsTarget: java.lang.String)
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .customDomain(customDomain.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly =
    zio.aws.apprunner.model.AssociateCustomDomainResponse.wrap(buildAwsValue())
}
object AssociateCustomDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AssociateCustomDomainResponse =
      zio.aws.apprunner.model.AssociateCustomDomainResponse(
        dnsTarget,
        serviceArn,
        customDomain.asEditable
      )
    def dnsTarget: String
    def serviceArn: AppRunnerResourceArn
    def customDomain: zio.aws.apprunner.model.CustomDomain.ReadOnly
    def getDnsTarget: ZIO[Any, Nothing, String] = ZIO.succeed(dnsTarget)
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getCustomDomain
        : ZIO[Any, Nothing, zio.aws.apprunner.model.CustomDomain.ReadOnly] =
      ZIO.succeed(customDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
  ) extends zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly {
    override val dnsTarget: String = impl.dnsTarget(): String
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val customDomain: zio.aws.apprunner.model.CustomDomain.ReadOnly =
      zio.aws.apprunner.model.CustomDomain.wrap(impl.customDomain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainResponse
  ): zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly =
    new Wrapper(impl)
}
