package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.KmsKeyArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EncryptionConfiguration(kmsKey: KmsKeyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.EncryptionConfiguration
      .builder()
      .kmsKey(KmsKeyArn.unwrap(kmsKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly =
    zio.aws.apprunner.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.EncryptionConfiguration =
      zio.aws.apprunner.model.EncryptionConfiguration(kmsKey)
    def kmsKey: KmsKeyArn
    def getKmsKey: ZIO[Any, Nothing, KmsKeyArn] = ZIO.succeed(kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.EncryptionConfiguration
  ) extends zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly {
    override val kmsKey: KmsKeyArn =
      zio.aws.apprunner.model.primitives.KmsKeyArn(impl.kmsKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.EncryptionConfiguration
  ): zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
