package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.VpcConnectorName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcConnectorRequest(
    vpcConnectorName: VpcConnectorName,
    subnets: Iterable[String],
    securityGroups: Option[Iterable[String]] = None,
    tags: Option[Iterable[zio.aws.apprunner.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorRequest = {
    import CreateVpcConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorRequest
      .builder()
      .vpcConnectorName(
        VpcConnectorName.unwrap(vpcConnectorName): java.lang.String
      )
      .subnets(subnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CreateVpcConnectorRequest.ReadOnly =
    zio.aws.apprunner.model.CreateVpcConnectorRequest.wrap(buildAwsValue())
}
object CreateVpcConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CreateVpcConnectorRequest =
      zio.aws.apprunner.model.CreateVpcConnectorRequest(
        vpcConnectorName,
        subnets,
        securityGroups.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcConnectorName: VpcConnectorName
    def subnets: List[String]
    def securityGroups: Option[List[String]]
    def tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]]
    def getVpcConnectorName: ZIO[Any, Nothing, VpcConnectorName] =
      ZIO.succeed(vpcConnectorName)
    def getSubnets: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorRequest
  ) extends zio.aws.apprunner.model.CreateVpcConnectorRequest.ReadOnly {
    override val vpcConnectorName: VpcConnectorName =
      zio.aws.apprunner.model.primitives
        .VpcConnectorName(impl.vpcConnectorName())
    override val subnets: List[String] = impl
      .subnets()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val securityGroups: Option[List[String]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorRequest
  ): zio.aws.apprunner.model.CreateVpcConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
