package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.ConnectionName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateConnectionRequest(
    connectionName: ConnectionName,
    providerType: zio.aws.apprunner.model.ProviderType,
    tags: Option[Iterable[zio.aws.apprunner.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateConnectionRequest = {
    import CreateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateConnectionRequest
      .builder()
      .connectionName(ConnectionName.unwrap(connectionName): java.lang.String)
      .providerType(providerType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CreateConnectionRequest.ReadOnly =
    zio.aws.apprunner.model.CreateConnectionRequest.wrap(buildAwsValue())
}
object CreateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CreateConnectionRequest =
      zio.aws.apprunner.model.CreateConnectionRequest(
        connectionName,
        providerType,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionName: ConnectionName
    def providerType: zio.aws.apprunner.model.ProviderType
    def tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]]
    def getConnectionName: ZIO[Any, Nothing, ConnectionName] =
      ZIO.succeed(connectionName)
    def getProviderType
        : ZIO[Any, Nothing, zio.aws.apprunner.model.ProviderType] =
      ZIO.succeed(providerType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateConnectionRequest
  ) extends zio.aws.apprunner.model.CreateConnectionRequest.ReadOnly {
    override val connectionName: ConnectionName =
      zio.aws.apprunner.model.primitives.ConnectionName(impl.connectionName())
    override val providerType: zio.aws.apprunner.model.ProviderType =
      zio.aws.apprunner.model.ProviderType.wrap(impl.providerType())
    override val tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateConnectionRequest
  ): zio.aws.apprunner.model.CreateConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
