package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.ImageIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageRepository(
    imageIdentifier: ImageIdentifier,
    imageConfiguration: Option[zio.aws.apprunner.model.ImageConfiguration] =
      None,
    imageRepositoryType: zio.aws.apprunner.model.ImageRepositoryType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ImageRepository = {
    import ImageRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ImageRepository
      .builder()
      .imageIdentifier(
        ImageIdentifier.unwrap(imageIdentifier): java.lang.String
      )
      .optionallyWith(imageConfiguration.map(value => value.buildAwsValue()))(
        _.imageConfiguration
      )
      .imageRepositoryType(imageRepositoryType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ImageRepository.ReadOnly =
    zio.aws.apprunner.model.ImageRepository.wrap(buildAwsValue())
}
object ImageRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ImageRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ImageRepository =
      zio.aws.apprunner.model.ImageRepository(
        imageIdentifier,
        imageConfiguration.map(value => value.asEditable),
        imageRepositoryType
      )
    def imageIdentifier: ImageIdentifier
    def imageConfiguration
        : Option[zio.aws.apprunner.model.ImageConfiguration.ReadOnly]
    def imageRepositoryType: zio.aws.apprunner.model.ImageRepositoryType
    def getImageIdentifier: ZIO[Any, Nothing, ImageIdentifier] =
      ZIO.succeed(imageIdentifier)
    def getImageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.ImageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("imageConfiguration", imageConfiguration)
    def getImageRepositoryType
        : ZIO[Any, Nothing, zio.aws.apprunner.model.ImageRepositoryType] =
      ZIO.succeed(imageRepositoryType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ImageRepository
  ) extends zio.aws.apprunner.model.ImageRepository.ReadOnly {
    override val imageIdentifier: ImageIdentifier =
      zio.aws.apprunner.model.primitives.ImageIdentifier(impl.imageIdentifier())
    override val imageConfiguration
        : Option[zio.aws.apprunner.model.ImageConfiguration.ReadOnly] = scala
      .Option(impl.imageConfiguration())
      .map(value => zio.aws.apprunner.model.ImageConfiguration.wrap(value))
    override val imageRepositoryType
        : zio.aws.apprunner.model.ImageRepositoryType =
      zio.aws.apprunner.model.ImageRepositoryType
        .wrap(impl.imageRepositoryType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ImageRepository
  ): zio.aws.apprunner.model.ImageRepository.ReadOnly = new Wrapper(impl)
}
