package zio.aws.apprunner.model
import java.lang.Integer
import zio.aws.apprunner.model.primitives.{
  DescribeCustomDomainsMaxResults,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCustomDomainsRequest(
    serviceArn: AppRunnerResourceArn,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeCustomDomainsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest = {
    import DescribeCustomDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeCustomDomainsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeCustomDomainsRequest.ReadOnly =
    zio.aws.apprunner.model.DescribeCustomDomainsRequest.wrap(buildAwsValue())
}
object DescribeCustomDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.DescribeCustomDomainsRequest =
      zio.aws.apprunner.model.DescribeCustomDomainsRequest(
        serviceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceArn: AppRunnerResourceArn
    def nextToken: Option[String]
    def maxResults: Option[DescribeCustomDomainsMaxResults]
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeCustomDomainsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest
  ) extends zio.aws.apprunner.model.DescribeCustomDomainsRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeCustomDomainsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.apprunner.model.primitives
          .DescribeCustomDomainsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest
  ): zio.aws.apprunner.model.DescribeCustomDomainsRequest.ReadOnly =
    new Wrapper(impl)
}
