package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.UUID
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PauseServiceResponse(
    service: zio.aws.apprunner.model.Service,
    operationId: Option[UUID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.PauseServiceResponse = {
    import PauseServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.PauseServiceResponse
      .builder()
      .service(service.buildAwsValue())
      .optionallyWith(
        operationId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.operationId)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.PauseServiceResponse.ReadOnly =
    zio.aws.apprunner.model.PauseServiceResponse.wrap(buildAwsValue())
}
object PauseServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.PauseServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.PauseServiceResponse =
      zio.aws.apprunner.model.PauseServiceResponse(
        service.asEditable,
        operationId.map(value => value)
      )
    def service: zio.aws.apprunner.model.Service.ReadOnly
    def operationId: Option[UUID]
    def getService
        : ZIO[Any, Nothing, zio.aws.apprunner.model.Service.ReadOnly] =
      ZIO.succeed(service)
    def getOperationId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.PauseServiceResponse
  ) extends zio.aws.apprunner.model.PauseServiceResponse.ReadOnly {
    override val service: zio.aws.apprunner.model.Service.ReadOnly =
      zio.aws.apprunner.model.Service.wrap(impl.service())
    override val operationId: Option[UUID] = scala
      .Option(impl.operationId())
      .map(value => zio.aws.apprunner.model.primitives.UUID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.PauseServiceResponse
  ): zio.aws.apprunner.model.PauseServiceResponse.ReadOnly = new Wrapper(impl)
}
